<?php
/**
 * Class represents records from table button
 * {autogenerated}
 * @property int $button_id
 * @property string $hash
 * @property string $title
 * @property string $comment
 * @property string $paysys_id
 * @property string $product_id
 * @property string $saved_form_id
 * @property int $is_disabled
 * @see Am_Table
 */
class Button extends Am_Record
{
    function createInvoice()
    {
        $bp = $this->getDi()->billingPlanTable->load($this->billing_plan_id);
        $pr = $bp->getProduct();

        /* @var $invoice Invoice */
        $invoice = $this->getDi()->invoiceRecord;

        $paysys_id = $this->unserializeList($this->paysys_id);
        if (count($paysys_id) == 1) {
            $invoice->paysys_id = current($paysys_id);
        }

        $invoice->add($pr);

        if ($this->coupon) {
            $invoice->setCouponCode($this->coupon);
            $invoice->validateCoupon();
        }

        return $invoice;
    }
}

class ButtonTable extends Am_Table
{
    protected $_key = 'button_id';
    protected $_table = '?_button';
    protected $_recordClass = 'Button';

    public function insert(array $values, $returnInserted = false)
    {
        if (empty($values['hash'])) {
            $values['hash'] = $this->getDi()->security->randomString(12);
        }
        return parent::insert($values, $returnInserted);
    }
}